<!--
Product: Metronic (Tailwind)
Version: v9.2.4
-->
<!DOCTYPE html>
<html class="h-full" data-kt-theme="true" data-kt-theme-mode="light" dir="ltr" lang="en">
<head>
  <!-- Point back to /novademo/html/demo1/ from /authentication/classic/ -->
  <base href="../../">
  <title>Sign In - Nova Chain Investments</title>
  <meta charset="utf-8"/>
  <meta name="robots" content="follow, index"/>
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
  <meta name="description" content="Sign in to Nova Chain Investments"/>
  <meta name="twitter:site" content="@keenthemes"/>
  <meta name="twitter:creator" content="@keenthemes"/>
  <meta name="twitter:card" content="summary_large_image"/>
  <meta name="twitter:title" content="Metronic - Tailwind CSS Sign In"/>
  <meta name="twitter:description" content="Sign in page using Tailwind CSS"/>
  <meta name="twitter:image" content="assets/media/app/og-image.png"/>
  <meta property="og:url" content="https://127.0.0.1:8001/metronic-tailwind-html/demo1/authentication/classic/sign-in"/>
  <meta property="og:locale" content="en_US"/>
  <meta property="og:type" content="website"/>
  <meta property="og:site_name" content="@keenthemes"/>
  <meta property="og:title" content="Metronic - Tailwind CSS Sign In"/>
  <meta property="og:description" content="Sign in page using Tailwind CSS"/>
  <meta property="og:image" content="assets/media/app/og-image.png"/>
  <link rel="apple-touch-icon" sizes="180x180" href="assets/media/app/apple-touch-icon.png"/>
  <link rel="icon" type="image/png" sizes="32x32" href="assets/media/app/favicon-32x32.png"/>
  <link rel="icon" type="image/png" sizes="16x16" href="assets/media/app/favicon-16x16.png"/>
  <link rel="shortcut icon" href="assets/media/app/favicon.ico"/>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet"/>
  <link href="assets/vendors/apexcharts/apexcharts.css" rel="stylesheet"/>
  <link href="assets/vendors/keenicons/styles.bundle.css" rel="stylesheet"/>
  <link href="assets/css/styles.css" rel="stylesheet"/>
</head>
<body class="antialiased flex h-full text-base text-foreground bg-background">
  <!-- Theme Mode (same as other pages) -->
  <script>
    const defaultThemeMode='light';let themeMode;
    if(document.documentElement){
      if(localStorage.getItem('kt-theme')){themeMode=localStorage.getItem('kt-theme');}
      else if(document.documentElement.hasAttribute('data-kt-theme-mode')){themeMode=document.documentElement.getAttribute('data-kt-theme-mode');}
      else{themeMode=defaultThemeMode;}
      if(themeMode==='system'){themeMode=window.matchMedia('(prefers-color-scheme: dark)').matches?'dark':'light';}
      document.documentElement.classList.add(themeMode);
    }
  </script>

  <main id="page-content" class="w-full flex justify-center py-12">
    <div class="kt-card max-w-[370px] w-full">
      <form id="sign_in_form" class="kt-card-content flex flex-col gap-5 p-10" action="/novademo/html/demo1/authentication/classic/login.php" method="post" autocomplete="off" novalidate>
        <div class="text-center mb-2.5">
          <h3 class="text-lg font-medium text-mono leading-none mb-2.5">Sign in</h3>
          <div class="flex items-center justify-center font-medium">
            <span class="text-sm text-secondary-foreground me-1.5">Need an account?</span>
            <a class="text-sm link"
               href="/novademo/html/demo1/authentication/classic/sign-up.php"
               data-page="signup">Sign up</a>
          </div>
        </div>

        <!-- Email -->
        <div class="flex flex-col gap-1">
          <label class="kt-form-label font-normal text-mono" for="email">Email</label>
          <input id="email" class="kt-input" type="email" name="email" placeholder="you@example.com" required/>
        </div>

        <!-- Password -->
        <div class="flex flex-col gap-1">
          <div class="flex items-center justify-between gap-1">
            <label class="kt-form-label font-normal text-mono" for="password">Password</label>
            <a class="text-sm kt-link shrink-0"
               href="/novademo/html/demo1/authentication/classic/reset-password/enter-email.php"
               data-page="forgot">Forgot Password?</a>
          </div>
          <div class="kt-input" data-kt-toggle-password="true">
            <input id="password" name="password" type="password" placeholder="Enter Password" required/>
            <button class="kt-btn kt-btn-sm kt-btn-ghost kt-btn-icon bg-transparent! -me-1.5"
                    data-kt-toggle-password-trigger="true" type="button">
              <span class="kt-toggle-password-active:hidden">
                <i class="ki-filled ki-eye text-muted-foreground"></i>
              </span>
              <span class="hidden kt-toggle-password-active:block">
                <i class="ki-filled ki-eye-slash text-muted-foreground"></i>
              </span>
            </button>
          </div>
        </div>

        <!-- Remember me -->
        <label class="kt-label">
          <input class="kt-checkbox kt-checkbox-sm" name="remember" type="checkbox" value="1"/>
          <span class="kt-checkbox-label">Remember me</span>
        </label>

        <!-- Submit -->
        <button
          class="kt-btn kt-btn-primary"
          type="submit"
          style="display:inline-flex!important;align-self:flex-start!important;width:max-content!important;padding:.6rem 1rem;">
          Sign In
        </button>
      </form>
    </div>
  </main>

  <!-- Scripts -->
  <script src="assets/js/core.bundle.js"></script>
  <script src="assets/vendors/ktui/ktui.min.js"></script>
  <script src="assets/vendors/apexcharts/apexcharts.min.js"></script>
</body>
</html>
