﻿<?php
// showpass.php (dev helper) — uses table `users` and column `password_hash`

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Load EXACT config.php
$docRoot   = rtrim((string)($_SERVER['DOCUMENT_ROOT'] ?? ''), '/\\');
$configFile = $docRoot . '/novademo/html/demo1/config.php';
if (!is_file($configFile)) {
    http_response_code(500);
    echo 'Config not found at ' . htmlspecialchars($configFile);
    exit;
}
require_once $configFile;

// Build PDO
$pdo = $pdo ?? null;
if (!$pdo instanceof PDO && function_exists('get_pdo')) {
    try { $pdo = get_pdo(); } catch (Throwable $e) { $pdo = null; }
}
if (!$pdo instanceof PDO && defined('DB_HOST') && defined('DB_NAME') && defined('DB_USER') && defined('DB_PASS')) {
    try {
        $pdo = new PDO(
            'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=utf8mb4',
            DB_USER, DB_PASS,
            [PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION, PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC, PDO::ATTR_EMULATE_PREPARES=>false]
        );
    } catch (Throwable $e) { $pdo = null; }
}
if (!$pdo instanceof PDO) {
    $dbArray = isset($db) && is_array($db) ? $db : (isset($config['db']) && is_array($config['db']) ? $config['db'] : null);
    if ($dbArray) {
        $host = $dbArray['host'] ?? $dbArray['server'] ?? null;
        $name = $dbArray['name'] ?? $dbArray['dbname'] ?? null;
        $user = $dbArray['user'] ?? $dbArray['username'] ?? null;
        $pass = $dbArray['pass'] ?? $dbArray['password'] ?? null;
        if ($host && $name && $user && $pass) {
            try {
                $pdo = new PDO("mysql:host={$host};dbname={$name};charset=utf8mb4", $user, $pass, [
                    PDO::ATTR_ERRMODE=>PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE=>PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES=>false
                ]);
            } catch (Throwable $e) { $pdo = null; }
        }
    }
}
if (!$pdo instanceof PDO) { http_response_code(500); echo 'Database connection failed.'; exit; }

// CSRF
if (empty($_SESSION['csrf_showpass'])) { $_SESSION['csrf_showpass'] = bin2hex(random_bytes(16)); }
$csrfToken = $_SESSION['csrf_showpass'];

// Handle POST
$resultMsg = null; $resultType = null; $inputEmail = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $postedToken = $_POST['csrf'] ?? '';
    if (!hash_equals($csrfToken, (string)$postedToken)) {
        $resultType='error'; $resultMsg='Security check failed. Please reload the page.';
    } else {
        $inputEmail = trim((string)($_POST['email'] ?? ''));
        if ($inputEmail === '' || !filter_var($inputEmail, FILTER_VALIDATE_EMAIL)) {
            $resultType='error'; $resultMsg='Please enter a valid email address.';
        } else {
            $usersTable = 'users';
            try {
                $stmt = $pdo->prepare("SELECT `password_hash` FROM `{$usersTable}` WHERE `email` = ? LIMIT 1");
                $stmt->execute([$inputEmail]);
                $row = $stmt->fetch();

                if ($row && array_key_exists('password_hash', $row)) {
                    $hash = (string)$row['password_hash'];
                    $resultType='success';
                    $resultMsg='Stored password hash: ' . htmlspecialchars($hash, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8');
                } else {
                    $resultType='error'; $resultMsg='No user found with that email, or `password_hash` column missing.';
                }
            } catch (PDOException $e) {
                error_log('[showpass.php] PDO error: '.$e->getMessage());
                $resultType='error'; $resultMsg='A database error occurred. Please try again.';
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en"><head>
<meta charset="utf-8" /><meta name="viewport" content="width=device-width, initial-scale=1" />
<title>Show Password Hash</title>
<style>
 body{font-family:system-ui,Segoe UI,Roboto,Helvetica,Arial,sans-serif;background:#0f1320;color:#e5e7eb;margin:0;padding:24px}
 .container{max-width:720px;margin:0 auto}.card{background:#141a2a;border:1px solid #222b45;border-radius:12px;padding:24px;box-shadow:0 10px 20px rgba(0,0,0,.35)}
 h1{margin:0 0 12px;font-size:20px}.muted{color:#9aa3b2;margin-top:0}
 form{display:flex;gap:12px;flex-wrap:wrap;margin-top:16px}
 input[type="email"]{flex:1 1 360px;padding:10px 12px;border-radius:8px;border:1px solid #2a3555;background:#0c1020;color:#e5e7eb}
 button{padding:10px 16px;border:0;border-radius:8px;background:#3b82f6;color:white;cursor:pointer}
 button:hover{filter:brightness(1.1)}.alert{margin-top:16px;padding:12px;border-radius:8px}
 .alert.success{background:#09351d;color:#a7f3d0;border:1px solid #065f46}
 .alert.error{background:#3b0d0d;color:#fecaca;border:1px solid #7f1d1d}.footnote{color:#9aa3b2;font-size:12px;margin-top:16px}
 code{background:#0b1120;padding:2px 4px;border-radius:4px}
</style>
</head>
<body>
<div class="container"><div class="card">
    <h1>Show Password Hash (dev)</h1>
    <p class="muted">Reads hash from table <code>users</code>, column <code>password_hash</code>.</p>

    <?php if ($resultMsg !== null): ?>
        <div class="alert <?= $resultType === 'success' ? 'success' : 'error' ?>">
            <?= $resultType === 'success' ? $resultMsg : htmlspecialchars($resultMsg, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') ?>
        </div>
    <?php endif; ?>

    <form method="post" action="">
        <input type="hidden" name="csrf" value="<?= htmlspecialchars($csrfToken, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') ?>">
        <input type="email" name="email" placeholder="you@example.com" required value="<?= htmlspecialchars($inputEmail, ENT_QUOTES | ENT_SUBSTITUTE, 'UTF-8') ?>">
        <button type="submit">Get Hash</button>
    </form>
</div></div>
</body></html>
