﻿<!--
Product: Metronic (Tailwind)
Version: v9.2.4
-->
<!DOCTYPE html>
<html class="h-full" data-kt-theme="true" data-kt-theme-mode="light" dir="ltr" lang="en">
<head>
  <base href="../../../">
  <title>Enter Email - Nova Chain Investments</title>
  <meta charset="utf-8"/>
  <meta name="robots" content="follow, index"/>
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
  <meta name="description" content="Enter your email to reset your password"/>
  <meta name="twitter:site" content="@keenthemes"/>
  <meta name="twitter:creator" content="@keenthemes"/>
  <meta name="twitter:card" content="summary_large_image"/>
  <meta name="twitter:title" content="Metronic - Tailwind CSS Enter Email"/>
  <meta name="twitter:description" content="Enter email to reset password, using Tailwind CSS"/>
  <meta name="twitter:image" content="assets/media/app/og-image.png"/>
  <meta property="og:url" content="https://127.0.0.1:8001/metronic-tailwind-html/demo1/authentication/classic/reset-password/enter-email"/>
  <meta property="og:locale" content="en_US"/>
  <meta property="og:type" content="website"/>
  <meta property="og:site_name" content="@keenthemes"/>
  <meta property="og:title" content="Metronic - Tailwind CSS Enter Email"/>
  <meta property="og:description" content="Enter email to reset password, using Tailwind CSS"/>
  <meta property="og:image" content="assets/media/app/og-image.png"/>
  <link rel="apple-touch-icon" sizes="180x180" href="assets/media/app/apple-touch-icon.png"/>
  <link rel="icon" type="image/png" sizes="32x32" href="assets/media/app/favicon-32x32.png"/>
  <link rel="icon" type="image/png" sizes="16x16" href="assets/media/app/favicon-16x16.png"/>
  <link rel="shortcut icon" href="assets/media/app/favicon.ico"/>
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet"/>
  <link href="assets/vendors/apexcharts/apexcharts.css" rel="stylesheet"/>
  <link href="assets/vendors/keenicons/styles.bundle.css" rel="stylesheet"/>
  <link href="assets/css/styles.css" rel="stylesheet"/>
</head>
<body class="antialiased flex h-full text-base text-foreground bg-background">
  <!-- Theme Mode -->
  <script>
    const defaultThemeMode='light';let themeMode;
    if(document.documentElement){
      if(localStorage.getItem('kt-theme')){themeMode=localStorage.getItem('kt-theme');}
      else if(document.documentElement.hasAttribute('data-kt-theme-mode')){themeMode=document.documentElement.getAttribute('data-kt-theme-mode');}
      else{themeMode=defaultThemeMode;}
      if(themeMode==='system'){themeMode=window.matchMedia('(prefers-color-scheme: dark)').matches?'dark':'light';}
      document.documentElement.classList.add(themeMode);
    }
  </script>

  <main id="page-content" class="w-full flex justify-center py-12">
    <div class="kt-card max-w-[370px] w-full">
      <form id="reset_password_enter_email_form" class="kt-card-content flex flex-col gap-5 p-10" action="/novademo/html/demo1/authentication/classic/reset-password/enter-email.process.php" method="post">
        <div class="text-center">
          <h3 class="text-lg font-medium text-mono">Your Email</h3>
          <span class="text-sm text-secondary-foreground">Enter your email to reset password</span>
        </div>

        <?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
if (!empty($_SESSION['enter_email_error'])): ?>
  <label class="kt-form-label text-red-600" role="alert">
    <?php echo htmlspecialchars($_SESSION['enter_email_error']); ?>
  </label>
<?php endif; ?>

        <div class="flex flex-col gap-1">
          <label class="kt-form-label font-normal text-mono" for="reset_email">Email</label>
          <?php if (session_status() === PHP_SESSION_NONE) { session_start(); } unset($_SESSION['enter_email_error'], $_SESSION['enter_email_value']); ?>
          <input id="reset_email" class="kt-input" type="email" name="email" placeholder="you@example.com" value="<?php if (!empty($_SESSION['enter_email_value'])) { echo htmlspecialchars($_SESSION['enter_email_value']); } ?>" required/>
        </div>

        <!-- Compact, content-wide button (same fix you'd apply to Sign Up) -->
        <button type="submit"
                class="kt-btn kt-btn-primary inline-flex justify-center self-start"
                style="width:max-content!important;display:inline-flex!important;align-self:flex-start!important;padding:.6rem 1rem;gap:.5rem;">
          Continue
          <i class="ki-filled ki-black-right"></i>
        </button>
      </form>
    </div>
  </main>

  <!-- Scripts -->
  <script src="assets/js/core.bundle.js"></script>
  <script src="assets/vendors/ktui/ktui.min.js"></script>
  <script src="assets/vendors/apexcharts/apexcharts.min.js"></script>
</body>
</html>
